/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.network;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.config.ConfigHandler;
import com.chaosthedude.naturescompass.items.NaturesCompassItem;
import com.chaosthedude.naturescompass.util.CompassState;
import com.chaosthedude.naturescompass.util.ItemUtils;
import com.chaosthedude.naturescompass.util.PlayerUtils;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class TeleportPacket {
    public TeleportPacket() {
    }

    public TeleportPacket(PacketBuffer buf) {
    }

    public void fromBytes(PacketBuffer buf) {
    }

    public void toBytes(PacketBuffer buf) {
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ItemStack stack = ItemUtils.getHeldNatureCompass((PlayerEntity)((NetworkEvent.Context)ctx.get()).getSender());
            if (!stack.func_190926_b()) {
                NaturesCompassItem natureCompass = (NaturesCompassItem)stack.func_77973_b();
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (((Boolean)ConfigHandler.GENERAL.allowTeleport.get()).booleanValue() && PlayerUtils.canTeleport((PlayerEntity)player)) {
                    if (natureCompass.getState(stack) == CompassState.FOUND) {
                        int x = natureCompass.getFoundBiomeX(stack);
                        int z = natureCompass.getFoundBiomeZ(stack);
                        int y = this.findValidTeleportHeight(player.func_130014_f_(), x, z);
                        player.func_184210_p();
                        player.field_71135_a.func_147364_a((double)x, (double)y, (double)z, player.field_71109_bG, player.field_70125_A);
                        if (!player.func_184613_cA()) {
                            player.func_213293_j(player.func_213322_ci().func_82615_a(), 0.0, player.func_213322_ci().func_82616_c());
                            player.func_230245_c_(true);
                        }
                    }
                } else {
                    NaturesCompass.logger.warn("Player " + player.func_145748_c_().getString() + " tried to teleport but does not have permission.");
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private int findValidTeleportHeight(World world, int x, int z) {
        int downY;
        int startY;
        int upY = startY = world.func_181545_F();
        for (downY = startY; !(this.isValidTeleportPosition(world, new BlockPos(x, upY, z)) || this.isValidTeleportPosition(world, new BlockPos(x, downY, z)) || upY >= 255 && downY <= 1); ++upY, --downY) {
        }
        BlockPos upPos = new BlockPos(x, upY, z);
        BlockPos downPos = new BlockPos(x, downY, z);
        if (upY < 255 && this.isValidTeleportPosition(world, upPos)) {
            return upY;
        }
        if (downY > 1 && this.isValidTeleportPosition(world, downPos)) {
            return downY;
        }
        return 256;
    }

    private boolean isValidTeleportPosition(World world, BlockPos pos) {
        return !world.func_180495_p(pos).func_200132_m() && Block.func_220064_c((IBlockReader)world, (BlockPos)pos.func_177977_b());
    }
}

